﻿using System;

namespace KursBeispiele
{
    class Program
    {
        static void Main(string[] args)
        {
            //Für die Klassendefinition ist es durchaus
            //sinnvoll immer public (oder internal) zu verwenden
            //für beinhaltete Objekte sollte immer private
            //verwendet werden außer diese müssen vererbt (protected)
            //oder gar von außen zugreifbar (public) sein - 
            //bei internal gelten die entsprechenden Modifizierer
            PrivateKlasse pik = new PrivateKlasse();
            PublicKlasse puk = new PublicKlasse();
            InternalKlasse ikl = new InternalKlasse();
            //Der andere Konstruktor ist nicht öffentlich und kann daher nicht aufgerufen werden
            //Dies sorgt für klareren Codeaufbau
            //InternalKlasse ikl = new InternalKlasse(7);

            Console.Read();
        }
    }

    //Es ist nicht erlaubt explizit eine Klasse private zu machen
    //private class PrivateKlasse
    class PrivateKlasse
    {
    }

    //Da PrivateKlasse private ist können wir nicht
    //public davon erben - beide müssen public sein oder
    //private - oder PublicKlasse private und PrivateKlasse
    //public
    //public class PublicKlasse : PrivateKlasse
    class PublicKlasse : PrivateKlasse
    {
    }

    //Kann nur in diesem Projekt (d.h. in dieser *.exe bzw.
    //in dieser *.dll) verwendet werden
    internal class InternalKlasse
    {
        int nr;

        //Öffentlich sichtbarer Konstruktor
        public InternalKlasse() : this(5)
        {
            Console.WriteLine("Ich bin der öffentliche Konstruktor!");
        }

        //Konstruktor kann nicht von außerhalb verwendet werden
        //nur intern oder von anderen Konstruktoren
        private InternalKlasse(int nr)
        {
            this.nr = nr;
            Console.WriteLine("Die Nummer wurde gesetzt");
        }
    }
}
